unit NyelvEszU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    Button2: TButton;
    MainMenu1: TMainMenu;
    NyelvLanguage1: TMenuItem;
    MagyarHungarian1: TMenuItem;
    EnglishAngol1: TMenuItem;
    Image1: TImage;
    procedure MagyarHungarian1Click(Sender: TObject);
    procedure EnglishAngol1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// Bitkp betltse erforrs DLL-bl
procedure LoadDLLBmp(Lib:THandle; BmpId:Integer; Dest:TBitmap);
resourcestring
 Err1 = 'Nem betlthet %s (%d)';
 Err2 = 'Az #%d erforrs nem tallhat (%s)';
 Err3 = 'A #%d bitkp hibs formtum';
var
  rInfo,hMemory: THandle;
  rSize: Longint;
  pData: PByte;
  BmpHdr: TBitmapFileHeader;
  stream: TMemoryStream;
begin
  if Lib < HINSTANCE_ERROR then Exit;
  // A bitkp megkeresse a knyvtrban
  rInfo := FindResource(Lib, MakeIntResource(BmpId), rt_Bitmap);
  if rInfo = 0 then
     raise Exception.CreateFmt(Err2,[BmpId,'FindResource']);
  // A bitkp betltse globlis memriterletre
  hMemory := LoadResource(Lib,rInfo);
  try
    if hMemory = 0 then
       raise Exception.CreateFmt(Err2,[BmpId,'LoadResource']);
    // A globlis memriblokk rgztse, a mutatval trtn
    // elrshez
    pData := LockResource(hMemory);
    try
      // A bitkp mrete
      rSize := SizeofResource(Lib,rInfo);
      if rSize = 0 then
        raise Exception.CreateFmt(Err3,[BmpId]);
      // A bitkpet memriafolyamba msoljuk
      stream := TMemoryStream.Create;
      try
        // Bitkp fjltpusjel: BM
        BmpHdr.bfType := $4D42;
        stream.SetSize(sizeof(BmpHdr)+rSize);
        stream.Write(BmpHdr,sizeof(BmpHdr));
        stream.Write(pData^,rSize);
        stream.Seek(0,0);
        Dest.LoadFromStream(stream);
      finally
        stream.Free;
      end;
    finally
      UnlockResource(hMemory);
    end;
  finally
    FreeResource(hMemory);
  end;
end;

// A szvegek s a bitkp betltse az erforrsbl
procedure LoadResources(lib:string);
var
  DLLleiro : THandle;
  Puffer   : array[0..100] of char;
begin
   DLLLeiro:=LoadLibrary(PChar(lib));
   if DLLleiro<32 then
      begin
        beep; exit;
      end;
   LoadDLLBmp(DLLLeiro, 5, Form1.Image1.Picture.Bitmap);
   LoadString(DLLLeiro, 1, Puffer, Sizeof(puffer));
   Form1.Button1.Caption:=Puffer;
   LoadString(DLLLeiro, 2, Puffer, Sizeof(puffer));
   Form1.Button2.Caption:=Puffer;
   LoadString(DLLLeiro, 3, Puffer, Sizeof(puffer));
   Form1.Label1.Caption:=Puffer;
   LoadString(DLLLeiro, 3, Puffer, Sizeof(puffer));
   Form1.Label1.Caption:=Puffer;
   LoadString(DLLLeiro, 4, Puffer, Sizeof(puffer));
   Form1.Label2.Caption:=Puffer;
   FreeLibrary(DllLeiro);
end;

// Magyar belltsok
procedure TForm1.MagyarHungarian1Click(Sender: TObject);
begin
   LoadResources('HUN.DLL');
end;

// Angol belltsok
procedure TForm1.EnglishAngol1Click(Sender: TObject);
begin
   LoadResources('ENG.DLL');
end;

// Szmts
procedure TForm1.Button1Click(Sender: TObject);
begin
    Edit2.text:=inttostr(sqr(strToInt(Edit1.text)));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   LoadResources('HUN.DLL');
end;

end.
